//******************************************************************************
//  MSP-FET430x110 Demo - Timer_A Toggle P1.0, CCR1 Contmode ISR, DCO SMCLK 
//
//  Description; Toggle P1.0 using using software and TA_1 ISR. Toggle rate is 
//  set at 50000 DCO/SMCLK cycles. Default DCO frequency used for TACLK. 
//  Durring the TA_1 ISR P0.1 is toggled and 50000 clock cycles are added to 
//  CCR1.  TA_1 ISR is triggered exactly 50000 cycles. CPU is normally off and
//  used only durring TA_ISR. Proper use of TAIV interrupt vector generator
//  demonstrated.   
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800k 
//
//               MSP430F1121
//            -----------------
//        /|\|              XIN|-  
//         | |                 |
//         --|RST          XOUT|-
//           |                 |
//           |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  "msp430x11x1.h"

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, clear TAR
  CCTL1 = CCIE;                         // CCR1 interrupt enabled
  CCR1 = 50000;
  P1DIR |= 0x01;                        // P1.0 output
  TACTL |= MC1;                         // Start Timer_A in continuous mode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A(void) __interrupt [TIMERA1_VECTOR] 
{
  switch( TAIV )
  {
  case  2:                              // CCR1 
    {
    P1OUT ^= 0x01;                      // Toggle P1.0
    CCR1 += 50000;                      // Add Offset to CCR1
    }
           break;
  case  4: break;                       // CCR2 not used 
  case 10: break;                       // overflow not used
 }
}

