//******************************************************************************
//  MSP-FET430P440 Demo - Timer_A Toggle P5.1, CCR0 Contmode ISR, DCO SMCLK  
//
//  Description; Toggle P5.1 using using software and TA_0 ISR. Toggle rate is 
//  set at 50000 DCO/SMCLK cycles. Default DCO frequency used for TACLK. 
//  Durring the TA_0 ISR P5.1 is toggled and 50000 clock cycles are added to 
//  CCR0.  TA_0 ISR is triggered exactly 50000 cycles. CPU is normally off and
//  used only durring TA_ISR. 
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800kHz
//
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, clear TAR
  CCTL0 = CCIE;                         // CCR0 interrupt enabled
  CCR0 = 50000;
  P5DIR |= 0x02;                        // P5.1 output
  TACTL |= MC1;                         // Start Timer_A in continuous mode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A (void) __interrupt[TIMERA0_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1
  CCR0 += 50000;                        // Add Offset to CCR0
}

