//******************************************************************************
//  MSP-FET430P440 Demo - BasicTimer Toggle P5.1 using ISR, 32kHz SMCLK 
//
//  Description; This program will toggle P5.1 by xor'ing P5.1 inside of
//  a basic timer ISR. ACLK used to clock basic timer. 
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//		  MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32kHz
//          --|RST          XOUT|-
//            |                 |
//            |             P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  IE2 |= BTIE;                          // Enable BT interrupt
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  BTCTL = BTDIV + BTIP1 + BTIP0;        // 125ms interrupt       
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Basic Timer interrupt service routine
void basic_timer(void) __interrupt[BASICTIMER_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

