// D437V example of using the ADC12 and LCD modules.
// The input is A7, the potentiometer.  Twiddling the pot will
// change the display on the LCD.

#include <msp430x43x.h>
#include <In430.h>
#include <string.h>
#include "vi322.h"

void
main(void)
{
  // Stop watchdog timer.
  WDTCTL = WDTHOLD + WDTPW;
  
  // Set port functions.
  P2SEL = 0xc0;
  P3SEL = 0xff;
  P4SEL = 0xff;
  P5SEL = 0x03;
  
  // Set up basic timer for LCD operation.
  BTCTL = 0x24;

  // Set up LCD as static mode, 40 segment drive lines.
  LCDCTL = 0xe5;

  // Clear LCD.
  memset(&LCDM1, 0, 20);
  
  // Enable A/D channel A7.
  P6SEL |= 0x80;

  // Intnternal reference, channel A10.
  ADC12MCTL0 = SREF_1 | INCH_7;
  ADC12CTL0 = ADC12ON + SHT0_15 + REFON + REF2_5V | MSC;      // Turn on ADC12, set sampling time
  ADC12CTL1 = SHP+CONSEQ_2;             // Use sampling timer, set mode
  ADC12IE = 0x01;                       // Enable ADC12IFG.0
  ADC12CTL0 |= ENC;                     // Enable conversions
  ADC12CTL0 |= ADC12SC;                 // Start conversion

  // Let interrupt processing commence.
  _EINT();
  
  // All processing is done in the interrupt handlers.
  // Enter low power mode 0 and, if we come out of it,
  // go back.
  for (;;)
    {
      _BIS_SR(LPM0_bits);
    }
}

void
ADC12ISR(void) __interrupt[ADC_VECTOR]
{
  // Scale conversion from 0-4095 to 0-1000 and show it.
  vi_322_show_number((unsigned long)ADC12MEM0 * 1000 / 4095);
}
