// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// CTL template file to implement the timer tick using TIMERA.
//

#include <msp430.h>
#include <ctl_api.h>

// This defines the timeout period for a millisecond timer
#define MS_TIMEOUT 500   

void start_timer()
{
  TACTL = TASSEL1+TACLR;
  CCTL0 = CCIE;
  CCR0 = MS_TIMEOUT;
  TACTL |= MC0;
}

void TimerA0_IRQ(void) __ctl_interrupt[TIMERA0_VECTOR]
{
  ctl_increment_tick_from_isr();
  CCR0 += MS_TIMEOUT;  
}

                             
                                          
