//******************************************************************************
//  MSP-FET430P440 Demo - USART1 UART 19200 Echo ISR, DCO SMCLK 
//
//  Description; Echo a received character, RX ISR used. Normal mode is LPM0, 
//  USART1 RX interrupt triggers TX Echo. 
//  ACLK = LFXT1 = 32768Hz,  MCLK = SMCLK = UCLK0 = DCOCLK = 1048576
//  Baud rate divider with 1048576hz = 1048576Hz/19200 ~ 55 (0036h)
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//              
//                MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32768Hz  
//          --|RST          XOUT|-
//            |                 |
//            |             P4.0|-----------> 
//            |                 | 19200 - 8N1
//            |             P4.1|<-----------
//
//       
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  UTCTL1 = SSEL1;                       // UCLK = SMCLK
  UBR01 = 0x36;                         // 1MHz 19200 
  UBR11 = 0x00;                         // 1MHz 19200
  UMCTL1 = 0x00;                        // no modulation
  UCTL1 = CHAR;                         // 8-bit character **SWRST**
  ME2 |= UTXE1 + URXE1;                 // Enable USART1 TXD/RXD
  IE2 |= URXIE1;                        // Enable USART1 RX interrupt
  P4SEL |= 0x03;                        // P4.0,1 = USART1 TXD/RXD
  P4DIR |= 0x01;                        // P4.0 output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                             
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

void usart1_rx (void) __interrupt[UART1RX_VECTOR] 
{
  while ((IFG2 & UTXIFG1) == 0);        // USART1 TX buffer ready?
  TXBUF1 = RXBUF1;                      // RXBUF1 to TXBUF0
}
