//******************************************************************************
//  MSP-FET430P440 Demo - Timer_B Toggle P5.1, overflow ISR, DCO SMCLK 
//
//  Description; This program will toggle P5.1 using software and the timer_B 
//  overflow ISR. In this example an ISR will trigger when TB overflows.  
//  Inside the ISR P5.1 is toggled.  Toggle rate is 16hz using DCO frequency 
//  of 1048576 with default FLL and watch crystal.	 
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = TBCLK = DCO = 32xACLK = 1.048576MHz
//  Proper use of TBIV interrupt vector generator demonstrated.
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//  
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TBCTL = TBSSEL1 + TBCLR + TBIE;       // SMCLK, clr. TBR, interrupt
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TBCTL |= MC1;                         // Start Timer_B in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer_B7 Interrupt Vector (TBIV) handler
void Timer_B(void) __interrupt [TIMERB1_VECTOR] 
{
 switch( TBIV )
 {
   case  2: break;                      // CCR1 not used
   case  4: break;                      // CCR2 not used
   case 14: P5OUT ^= 0x02;              // overflow
            break;
 }
}

