//******************************************************************************
//  MSP-FET430P440 Demo  FLL+ clock, runs internal DCO at 8Mhz
//
//  Description: This program demostrates setting the internalDCO to run at 
//  8Mhz with auto-calibration by the FLL+. 
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCOCLK = (n+1) x 2 x ACLK 
//  //*An external watch crystal is required on XIN/XOUT for ACLK*//	  
//
//                 MSP430F419
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32khz xtal
//          --|RST          XOUT|-                                       
//            |                 |
//            |             P1.1|--> MCLK = 8Mhz
//            |                 |
//            |             P1.5|--> ACLK = 32khz
//            |                 |
//
//  B. Merritt - meb
//  Texas Instruments Inc.
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************
#include "msp430x44x.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;       // stop watchdog timer
  SCFI0 |= FN_4;                  // x2 DCO frequency, 8MHz nominal DCO  
  SCFQCTL = 121;                  // (121+1) x 32768 x 2 = 7.99 Mhz
  FLL_CTL0 = DCOPLUS + XCAP18PF;  // DCO+ set so freq = xtal x D x N+1
  P1DIR = 0x22;                   // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                   // P1.1 & P1.5 to output MCLK & ACLK
  
  while(1);                       // loop in place
}
  
