//******************************************************************************
//  MSP-FET430P410 Demo - Timer_A Toggle P5.1, CCR0 upmode ISR, DCO SMCLK 
//
//  Description; toggle P5.1 using using software and TA_0 ISR. Timer_A is 
//  configured in upmode, thus the timer will overflow when TAR counts to CCR0.  
//  In this example, CCR0 is loaded with 20000. 
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800k 
//   
//
//           MSP430F413
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x41x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, clear TAR
  CCTL0 = CCIE;                         // CCR0 interrupt enabled
  CCR0 = 20000;
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TACTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A (void) __interrupt[TIMERA0_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

