//******************************************************************************
//  MSP-FET430P140 Demo - ADC12, Repeated Single Channel Conversions
//
//  This example shows how to perform repeated conversions on a single channel
//  using "repeat-single-channel" mode.  AVcc is used for the reference and 
//  repeated conversions are performed on Channel A0. Each conversion result 
//  is moved to an 8-element array called results[].  Test by applying a 
//  voltage to channel A0, then running. To view the conversion results, open a
//  watch window and view 'results.' 
// 
//
//               MSP430F149
//             ---------------
//            |               |
//            |      A0 (P6.0)|<---- Vin
//            |               |
//
//
//  M.Mitchell
//  Texas Instruments, Inc
//  January, 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include          "msp430x14x.h"        // Standard Equations

#define   Num_of_Results   8

static unsigned int results[Num_of_Results];  // Needs to be global in this
                                              // example. Otherwise, the
                                              // compiler removes it because it 
                                              // is not used for anything.

void main(void)
{ 
  WDTCTL = WDTPW+WDTHOLD;               // Stop watchdog timer
  P6SEL |= 0x01;                        // Enable A/D channel A0
  ADC12CTL0 = ADC12ON+SHT0_8+MSC    ;   // Turn on ADC12, set sampling time
  ADC12CTL1 = SHP+CONSEQ_2;             // Use sampling timer, set mode
  ADC12IE = 0x01;                       // Enable ADC12IFG.0
  ADC12CTL0 |= ENC;                     // Enable conversions
  _EINT();                              // Enable interrupts  
  ADC12CTL0 |= ADC12SC;                 // Start conversion
  _BIS_SR(LPM0_bits);                   // Enter LPM0
}

void ADC12ISR (void) __interrupt[ADC_VECTOR] 
{
  static unsigned int index = 0;
   
  results[index] = ADC12MEM0;           // Move results
  index = (index+1)%Num_of_Results;     // Increment results index, modulo
}
 
