// Copyright (c) 2004 Rowley Associates Limited.

var initialised = false;
var imgLeaf = new Image();
var imgBranchOpen = new Image();
var imgBranchClosed = new Image();
var currentNode;

function
pathsMatch(p1, p2)
{
  var p1l = p1.length;
  var p2l = p2.length;
  while (p1l-- && p2l--)
    {
      if(p1[p1l] != "." && p2[p2l] != "." && p1[p1l] != p2[p2l])
        return false;
    }
  return true;
}

function
findFirstElement(node, tag)
{
  var elements = node.getElementsByTagName(tag);
  return elements[0];
}

function
initialiseNode(node)
{
  if (node.tagName == "LI" && !node.isinitialised)
    {
      if (node.className == "branch")
        node.style.backgroundImage = "url(" + imgBranchClosed.src + ")"; 
      else if (node.className == "leaf")
        node.style.backgroundImage = "url(" + imgLeaf.src + ")"; 
      node.isinitialised = true;
    }
}

function
initialiseChildNodes(node)
{
  node = findFirstElement(node, "LI");
  while (node)
    {
      initialiseNode(node);
      node = node.nextSibling;
    }
}

function
toggleBranch(node)
{
  /* Toggle the open/closed status of a branch */
  if (node.isopen)
    {
      node.isopen = false;
      node.style.backgroundImage = "url(" + imgBranchClosed.src + ")";
      node = findFirstElement(node, "UL");
      if (node)
        node.style.display = "none";
    }
  else
    {
      node.isopen = true;
      node.isinitialised = true;
      node.style.backgroundImage = "url(" + imgBranchOpen.src + ")";
      node = findFirstElement(node, "UL");
      if (node)
        node.style.display = "block";
      initialiseChildNodes(node);
    }
}

function
toggleBranchEvent(event)
{
  /* Get the event */
  if (!event)
    event = window.event;

  /* Get the source of the event */
  if (event.target)
    target = event.target;
  else if (event.srcElement)
    target = event.srcElement;
  if (target.nodeType == 3) // defeat Safari bug
    target = target.parentNode;

  if (this == target)
    toggleBranch(this);

  return true;
}

function
openBranches(node)
{
  while (node)
    {
      if (node.tagName == "LI" && node.className == "branch" && !node.isopen)
        toggleBranch(node);
      node = node.parentNode;
    }
}

function
closeBranches(node)
{
  while (node)
    {
      if (node.tagName == "LI" && node.className == "branch" && node.isopen)
        toggleBranch(node);
      node = node.parentNode;
    }
}

function
findAndMarkCurrentNode(tree, currentURL)
{
  // Check to see if we can work out the current item.
  if (!currentURL)
    currentURL = location.href;
  var path1 = currentURL.split('/');
  var elements = tree.getElementsByTagName("a");
  for (var i = 0; i < elements.length; ++i)
    {
      path2 = elements[i].getAttribute("href").split('/');
      if (pathsMatch(path1, path2))
        {
          var element = elements[i].parentNode;
          /* Mark the current node */
          while (element)
            {
              if (element.tagName == "LI")
                {
                  element.id = "currentnode";
                  return element;
                }
              element = element.parentNode;
            }
        }
    }
  return null;
}

function
updateCurrentNode(currentURL)
{
  var elements = document.getElementsByTagName("div");
  for (var i = 0; i < elements.length; ++i)
    {
      var element = elements[i];
      if (element.id == "tree")
        {
          if (currentNode)
            {
              closeBranches(currentNode);
              currentNode.id = "";
            }
          currentNode = findAndMarkCurrentNode(element, currentURL);
          if (currentNode)
            {
              openBranches(currentNode);
              if (currentNode.scrollIntoView)
                currentNode.scrollIntoView();
              else
                window.scrollTo(currentNode.offsetLeft, currentNode.offsetTop);
            }
        }
    }
}

function
initialiseRootNodes(tree)
{
  node = findFirstElement(tree, "UL");
  while (node)
    {
      node.style.display = "block";
      var elements = node.getElementsByTagName("UL");
      for (var i = 0; i < elements.length; ++i)
        elements[i].style.display = "none";
      node = node.nextSibling;
      while (node && node != "UL")
        node = node.nextSibling;
    }
  initialiseChildNodes(tree);
}

function
initialiseTree(tree, imagePadding)
{
  var elements = tree.getElementsByTagName("LI");
  for (var i = 0; i < elements.length; ++i)
    {
      var element = elements[i];
      // The user has two options, either they can mark the LI nodes with the
      // class "branch" or "leaf" to tell us the node type and save the script
      // some work or the script can work it out.
      var isBranch;
      if (element.className == "branch")
        {
          isBranch = true;
        }
      else if (element.className == "leaf")
        {
          isBranch = false;
        }
      else
        {
          // User has not specified whether node is a branch or a leaf, so
          // we'll work it out.
          isBranch = element.getElementsByTagName("LI").length > 0;
          if (element.getElementsByTagName("LI").length > 0)
            {
              isBranch = true;
              element.className = "branch";
            }
          else
            {
              isBranch = false;
              element.className = "leaf";
            }
        }
      if (isBranch)
        {
          element.onclick = toggleBranchEvent;
        }
      element.style.paddingLeft = imagePadding;
      element.style.backgroundRepeat = "no-repeat";
    }

  initialiseRootNodes(tree);
}

function
initialiseTrees(leafImageURL, branchOpenImageURL, branchClosedImageURL, imagePadding)
{
  imgLeaf.src = leafImageURL;
  imgBranchOpen.src = branchOpenImageURL;
  imgBranchClosed.src = branchClosedImageURL;

  var elements = document.getElementsByTagName("div");
  for (var i = 0; i < elements.length; ++i)
    {
      var element = elements[i];
      if (element.id == "tree")
        initialiseTree(element, imagePadding);
    }
  initialised = true;
}

