function getState(state)
{
  if (state == 0x00)
    return "runnable";
  if (state == 0x1)
    return "timer wait";
  var stateStr;
  if ((state & 0x30) == 0x30)
    stateStr = "message queue receive";  
  else if ((state & 0x20) == 0x20)
    stateStr = "message queue post";  
  else if ((state & 0x10) == 0x10)
    stateStr = "semaphore";
  else if ((state & 0x04)==0x04)     
    stateStr = "event any";     
  else if ((state & 0x02)==0x02)
    stateStr = "event all";
  else
    return "invalid";
  if ((state & 0x01) == 0x01)      
    stateStr += "& timer wait";
  else
    stateStr += " wait";
  return stateStr;
}

function getregs(sp)
{
  var a = new Array();
  for (i=4;i<=15;i++) // r4-r15 saved
    {
      a[i] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
      sp+=2;
    }
  a[3] = 0; // r3 isn't saved  
  a[2] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); // r2/sr
  sp+=2;
  a[0] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); // r0/pc
  a[1] = sp; // r1/sp
  return a;
}

function update() 
{
  Threads.clear();
  x=Debug.evaluate("ctl_task_executing");
  if (x)
    {
      Threads.newqueue("Executing");
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      Threads.add(x.name, x.priority, "executing", null);
    }
  x=Debug.evaluate("ctl_task_list");
  if (x)
    Threads.newqueue("Waiting");
  count=0;
  while (x && count<10)
    {
      count++;
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      state = getState(x.state);
      Threads.add(x.name, x.priority, state, getregs(x.stack_pointer));
      x=x.next;
    }
}