//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Sample A0, AVcc, Set P1.0 if A0 > 0.2V 
//
//  Description; A single sample is made on A0 with reference to internal
//  1.5V Vref. Software sets ADC10SC to start sample and conversion - ADC10SC 
//  automatically cleared at EOC. ADC10 internal oscillator times sample (16x) 
//  and conversion. In Mainloop MSP430 waits in LPM0 to save power until ADC10
//  conversion complete, ADC10_ISR will force exit from any LPMx in Mainloop on
//  reti. If A0 > 0.2V, P1.0 set, else reset. 
//  //*MSP430F1232 or MSP430F1132 Device Required*//
//
//                MSP430F1232
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//        >---|A10          P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC10CTL0 = SREF_1 + ADC10SHT_2 + REFON + ADC10ON + ADC10IE;
  ADC10AE |= 0x01;                      // P2.0 ADC option select 
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  
  for (;;)                              
  {
    ADC10CTL0 |= ENC + ADC10SC;         // Sampling and conversion start
    _BIS_SR(CPUOFF + GIE);              // LPM0 with interrupts enabled
    if (ADC10MEM < 0x88)                // ADC10MEM = A0 > 0.2V?
    {
    P1OUT &= ~0x01;                     // Clear P1.0 LED off
    }
    else
    {
    P1OUT |= 0x01;                      // Set P1.0 LED on
    }
  }
}

// ADC10 interrupt service routine
void ADC10_ISR (void) __interrupt[ADC10_VECTOR] 
{
    _BIC_SR_IRQ(CPUOFF);                // Clear CPUOFF bit from 0(SR)
}
