//******************************************************************************
//  MSP-FET430P440 Demo - Timer_B Toggle P5.1, TBCCR0 Contmode ISR, DCO SMCLK 
//
//  Description; Toggle P5.1 using using software and TB_0 ISR. Toggle rate is 
//  set at 50000 DCO/SMCLK cycles. Default DCO frequency used for TBCLK. 
//  Durring the TB_0 ISR P5.1 is toggled and 50000 clock cycles are added to 
//  CCR0.  TB_0 ISR is triggered exactly 50000 cycles. CPU is normally off and
//  used only durring TB_ISR. 
//  ACLK = n/a, MCLK = SMCLK = TBCLK = DCO ~ 800kHz
//
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TBCTL = TBSSEL1 + TBCLR;              // SMCLK, clear TAR
  TBCCTL0 = CCIE;                       // CCR0 interrupt enabled
  TBCCR0 = 50000;
  P5DIR |= 0x02;                        // P5.1 output
  TBCTL |= MC1;                         // Start Timer_A in continuous mode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer B0 interrupt service routine
void Timer_B (void) __interrupt[TIMERB0_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1
  TBCCR0 += 50000;                      // Add Offset to CCR0
}

