//******************************************************************************
//  MSP-FET430P120 Demo - BasicClock MCLK configured with HF XTAL
//
//  Description; Proper selection of an external HF XTAL for MCLK is shown by
//  first polling the OSC fault until XTAL is stable - only then is MCLK
//  sourced by LFXT1.  MCLK/10 is on P1.1 driven by a software loop taking 
//  exactly 10 CPU cycles. 
//  ACLK = MCLK = LFXT1 = HF XTAL
//  //** HF XTAL NOT INSTALLED ON FET **//
//
//               MSP430F123(2)
//            -----------------
//        /|\|              XIN|-  
//         | |                 | HF XTAL (455k - 8Mhz)
//         --|RST          XOUT|-
//           |                 |
//           |             P1.1|-->MCLK/10 = HFXTAL/10
//           |             P2.0|-->ACLK = HFXTAL
//
//       
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x12x.h>

void main(void)
{
  unsigned int i;
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  BCSCTL1 |= XTS;                       // ACLK = LFXT1 = HF XTAL
  P2DIR |= 0x01;                        // P2.0 = output direction
  P2SEL |= 0x01;                        // P2.0 = ACLK function
  P1DIR |= 0x02;                        // P1.1 = output direction

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1+SELM0;               // MCLK = LFXT1 (safe)
  
  for (;;)                              
  {
    P1OUT |= 0x02;                      // P1.1 = 1
    P1OUT &= ~0x02;                     // P1.1 = 0
  }
}
