// SoftBaugh D1232 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Toggles the P2.4 LED (D1) on the D1232 under interrupt control.

#include <msp430x12x2.h>

void
main(void)
{
  // Stop watchdog.
  WDTCTL = WDTPW + WDTHOLD;

  // Drive off ACLK.
  TACTL = TASSEL0 + TACLR;

  // Enable CCR0 interrupt.
  CCTL0 = CCIE;

  // Set timer value.
  CCR0 = 16384;

  // P2.4 set to output.
  P2DIR |= 0x10;

  // Start Timer_A in continuous mode.
  TACTL |= MC1;

  // Enable interrupts.
  _EINT();                              

  // Put the CPU into a comatose state.
  for (;;)
    {
      _BIS_SR(CPUOFF);
    }
}

// Timer A0 interrupt service routine.
void
timera_isr(void) __interrupt[TIMERA0_VECTOR]
{
  // Toggle LED.
  P2OUT ^= 0x10;

  // Schedule next interrupt.
  CCR0 += 16384;
}
