// Texas Instruments December ATC Demo Board Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Flashes the message "HELLO" on the LCD under interrupt control.

#include <msp430x41x.h>

  .code
  
reset:
   mov.w #0x210, sp
   mov.w #WDTPW + WDTHOLD, &WDTCTL   // Stop watchdog.
   mov.w #XCAP10PF, &FLL_CTL0
   mov.w #TASSEL0+TACLR, &TACTL      // Drive off ACLK.
   mov.w #CCIE, &CCTL0               // Enable CCR0 interrupt.
   mov.w #16384, &CCR0               // Set timer value.
   bis.w #0x18, &P2DIR               // P2.3,4 set to output.
   mov.w #0x10, &P2OUT               // Initial LED state.
   bis.w #MC1, &TACTL                // Start Timer_A in continuous mode.
   mov.w #0, &P1OUT                  // Initialise ports
   mov.w #-1, &P1DIR
   mov.w #1, &P2OUT
   mov.w #-2, &P2DIR
   mov.w #0, &P3OUT
   mov.w #-1, &P3DIR
   mov.w #0, &P4OUT
   mov.w #-1, &P4DIR
   mov.w #0, &P5OUT
   mov.w #-1, &P5DIR
   mov.w #0, &P6OUT
   mov.w #-1, &P6DIR
   mov.w #0xfc, &P5SEL               // Enable R(LCD) + COM Lines.
   mov.w #LCDON+LCD4MUX+LCDP2, &LCDCTL // STK LCD 4Mux, S0-S23
   mov.w #0x33, &BTCTL                 // Initialise basic timer.
   mov.w #LCDMEM, r4
   mov.w #12, r5                       // Clear LCD memory
L1 mov.b #0, 0(r4)
   add.w #1, r4
   sub.w #1, r5
   jne   L1
   eint
L0 bis.w #CPUOFF, sr                 // Put the CPU into a comatose state.
   jmp L0

// Timer A0 interrupt service routine.
void
timera_isr:
   xor.w #0xba, &LCDMEM+6             // Flash message.
   xor.w #0xad, &LCDMEM+5
   xor.w #0xa4, &LCDMEM+4
   xor.w #0xa4, &LCDMEM+3
   xor.w #0xb7, &LCDMEM+2
   add.w #16384, &CCR0                 // Schedule next interrupt.
   reti

   .vectors
   .keep
   org  TIMERA0_VECTOR
   dw   timera_isr
   org  0x1e
   dw   reset
