//******************************************************************************
//  MSP-FET430P440 Demo - USART0 UART 9600 Echo ISR, DCO SMCLK 
//
//  Description; Echo a received character, RX ISR used. Normal mode is LPM0, 
//  USART0 RX interrupt triggers TX Echo. 
//  ACLK = LFXT1 = 32768Hz,  MCLK = SMCLK = UCLK0 = DCOCLK = 1048576
//  Baud rate divider with 1048576hz = 1048576Hz/9600 ~ 109 (006Dh)
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//              
//                MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32768Hz  
//          --|RST          XOUT|-
//            |                 |
//            |             P2.4|-----------> 
//            |                 | 9600 - 8N1
//            |             P2.5|<-----------
//
//       
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  UTCTL0 = SSEL1;                       // UCLK = SMCLK
  UBR00 = 0x6D;                         // 1MHz 9600 
  UBR10 = 0x00;                         // 1MHz 9600
  UMCTL0 = 0x00;                        // no modulation
  UCTL0 = CHAR;                         // 8-bit character *SWRST*
  ME1 |= UTXE0 + URXE0;                 // Enable USART0 TXD/RXD
  IE1 |= URXIE0;                        // Enable USART0 RX interrupt
  P2SEL |= 0x30;                        // P2.4,5 = USART0 TXD/RXD
  P2DIR |= 0x10;                        // P2.4 output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                             
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

void usart0_rx (void) __interrupt[UART0RX_VECTOR] 
{
  while ((IFG1 & UTXIFG0) == 0);        // USART0 TX buffer ready?
  TXBUF0 = RXBUF0;                      // RXBUF0 to TXBUF0
}
