//******************************************************************************
//  MSP-FET430P440 Demo - ADC12 Sample A0, AVcc 
//
//  Description; A simple single sample is made on A0 with refernce to Avcc.  
//  Software controls pulse on ADC12SC to sample analog input signal and start 
//  conversion. ADC12  internal oscillator times conversion. ADC12BUSY flag is 
//  polled for EOC. Conversion result saved in ADC12MEM0. 
//  // For acurate conversion, bias ADC12 references per device datasheet //  
//  
//                MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//  0-AVcc >--|A0               |
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC12CTL0 = ADC12ON;                  // ADC12ON
  ADC12CTL0 |= ENC;                     // Conversion enabled
  P6SEL |= 0x01;                        // P6.0 ADC option select 
  
  for (;;)                              
  {
    ADC12CTL0 |= ADC12SC;               // Sampling open
    ADC12CTL0 &= ~ADC12SC;              // Sampling closed, start conversion
    while ((ADC12CTL1 & ADC12BUSY) == 1);   // ADC12BUSY?
  }
}
