#ifndef __stdint_H
#define __stdint_H

#ifdef WIN32
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int32_t;
typedef signed __int64 int64_t;

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long uint32_t;
typedef unsigned __int64 uint64_t;

#else
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int32_t;
typedef signed long long int64_t;

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long uint32_t;
typedef unsigned long long uint64_t;
#endif

typedef int8_t int_least8_t;
typedef int16_t int_least16_t;
typedef int32_t int_least32_t;
typedef int64_t int_least64_t;

typedef uint8_t uint_least8_t;
typedef uint16_t uint_least16_t;
typedef uint32_t uint_least32_t;
typedef uint64_t uint_least64_t;

typedef int8_t int_fast8_t;
typedef int16_t int_fast16_t;
typedef int32_t int_fast32_t;
typedef int64_t int_fast64_t;

typedef uint8_t uint_fast8_t;
typedef uint16_t uint_fast16_t;
typedef uint32_t uint_fast32_t;
typedef uint64_t uint_fast64_t;

typedef int16_t intptr_t;
typedef uint16_t uintptr_t;

typedef int64_t intmax_t;
typedef uint64_t uintmax_t;

#define UINT8_MAX 255

#define INT8_MAX    127
#define INT8_MIN    (-128)

#define UINT16_MAX  65535

#define INT16_MIN   (-32767-1)
#define INT16_MAX   32767

#define UINT32_MAX  4294967295UL
#define INT32_MAX   2147483647L
#define INT32_MIN   (-2147483647L-1)

#define INT64_MIN  (-9223372036854775807LL-1)
#define INT64_MAX  9223372036854775807LL
#define UINT64_MAX 18446744073709551615ULL

#ifdef WIN32
#define INT8_C(x) (x)
#define UINT8(x) (x##U)
#define INT16_C(x) (x)
#define UINT16_C(x) (x##U)
#define INT32_C(x) (x##L)
#define UINT32_C(x) (x##UL)
#define INT64_C(x) ((int64_t)(x##L))
#define UINT64_C(x) ((uint64_t)(x##UL))
#else
#define INT8_C(x) (x)
#define UINT8(x) (x##U)
#define INT16_C(x) (x)
#define UINT16_C(x) (x##U)
#define INT32_C(x) (x##L)
#define UINT32_C(x) (x##UL)
#define INT64_C(x) (x##LL)
#define UINT64_C(x) (x##ULL)
#endif

#endif

