// SoftBaugh ES413 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Flashes the message "HELLO" on the LCD under interrupt control.

#include <msp430x41x.h>

  .code
  
reset:
   mov.w #0x210, sp
   mov.w #WDTPW + WDTHOLD, &WDTCTL   // Stop watchdog.
   mov.w #TASSEL0+TACLR, &TACTL      // Drive off ACLK.
   mov.w #CCIE, &CCTL0               // Enable CCR0 interrupt.
   mov.w #16384, &CCR0               // Set timer value.
   bis.b #0x01, &P1DIR               // P1.0 to output.
   mov.w #BT_fLCD_DIV32+0x24, &BTCTL // Set up LCD
   mov.w #0xfd, &LCDCTL
   mov.w #12, r4                     // Clear LCD memory
   mov.w #LCDMEM, r5
L1 mov.b #0, 0(r5)
   add.w #1, r5
   sub.w #1, r4
   jne   L1
   bis.w #MC1, &TACTL                // Start Timer_A in continuous mode.
   mov.b #-1, &P2SEL                 // Set up ports for LCD
   mov.b #-1, &P3SEL
   mov.b #-1, &P4SEL
   mov.b #-1, &P5SEL

   eint
L0 bis.w #CPUOFF, sr                 // Put the CPU into a comatose state.
   jmp L0

timera_isr:
   xor.b #0x0e, &LCDMEM+1            // H
   xor.b #0x70, &LCDMEM+2
   xor.b #0x8e, &LCDMEM+3            // E
   xor.b #0x21, &LCDMEM+4
   xor.b #0x8a, &LCDMEM+5            // L
   xor.b #0x8a, &LCDMEM+7            // L
   xor.b #0x8a, &LCDMEM+9            // O
   xor.b #0x51, &LCDMEM+10

   add.w #16384, &CCR0               // Schedule next interrupt.
   reti

   .vectors
   .keep
   org  TIMERA0_VECTOR
   dw   timera_isr
   org  RESET_VECTOR
   dw   reset
