//*******************************************************************************
//  MSP-FET430P440 Demo - Timer_A PWM TA1-2 upmode, 32kHz ACLK
//
//  Description; This program will generate a two PWM outputs on P1.2/2.0 using
//  Timer_A in an upmode.  The value in CCR0, 512, defines the period and the 
//  values in CCR1 and CCR1 the duty PWM cycles.  Using 32kHz ACLK as TACLK,
//  the timer period is 15.6ms with a 75% duty cycle on P1.2 and 25% on P2.0. 
//  Normal mode LPM3
//  ACLK = TACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576Mhz
//  //*External watch crystal installed on XIN XOUT is required for ACLK*//	  
//
//               MSP430F449
//            -----------------
//        /|\|              XIN|-  
//         | |                 | 32k
//         --|RST          XOUT|-
//           |                 |
//           |             P1.2|--> CCR1 - 75% PWM
//           |             P2.0|--> CCR2 - 25% PWM
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW +WDTHOLD;              // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TACTL = TASSEL0 + TACLR;              // ACLK, Clear Tar
  CCR0 = 512-1;                         // PWM Period
  CCTL1 = OUTMOD_7;                     // CCR1 reset/set
  CCR1 = 384;                           // CCR1 PWM duty cycle
  CCTL2 = OUTMOD_7;                     // CCR2 reset/set
  CCR2 = 128;                           // CCR2 PWM duty cycle
  P1DIR |= 0x04;                        // P1.2 output
  P1SEL |= 0x04;                        // P1.2 TA1 otion
  P2DIR |= 0x01;                        // P2.0 output
  P2SEL |= 0x01;                        // P2.0 TA2 otion
  TACTL |= MC0;                         // Start Timer_A in up mode
  
  for (;;)                            
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

