//******************************************************************************
//  MSP-FET430P410 Demo - FLL+ clock, Runs internal DCO at 2.45Mhz 
//
//  Description This program demostrates setting the internal DCO to run at 
//  2.4576Mhz with auto-calibration by the FLL+ circuitry.
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = (n+1) x ACLK 
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//                 MSP430F41x
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32khz xtal
//          --|RST          XOUT|-
//            |                 |
//            |             P1.1|--> MCLK = 2.4576Mhz
//            |                 |
//            |             P1.5|--> ACLK = 32khz
//            |                 |
//
//  B. Merritt - meb
//  Texas Instruments Inc.
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************
#include "msp430x41x.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;       // Stop watchdog timer
  SCFI0 |= FN_2;                  // x2 DCO, 4MHz nominal DCO  
  FLL_CTL0 = XCAP18PF;            // set load capacitance for xtal
  SCFQCTL = 74;                   // (74+1) x 32768 = 2.45Mhz
  
  P1DIR = 0x22;                   // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                   // P1.1 & P1.5 to output MCLK & ACLK
  
  while(1);                       // loop in place
}  
