//******************************************************************************
//  MSP-FET430P140 Demo - ADC12, Trigger Conversion With Timer_A
//
//  Description: Trigger an A/D conversion with Timer_A
//
//  This example shows how to trigger an A/D conversion with Timer_A.  A single 
//  ADC12 conversion on channel A0 is triggered from Timer_A.  The ADC12 
//  internal oscillator is used for sample and conversion timing.  Timer_A is 
//  configured to run continuously. AVcc is used for the reference. The 
//  conversion results are stored in ADC12MEM0. Test by applying a voltage to 
//  channel A0, then setting and running to a break point on the last 
//  instruction. To view the conversion results, open an ADC12 SFR window in 
//  C-Spy and view the contents of ADC12MEM0.
//
//
//               MSP430F149
//             ---------------
//            |               |
//            |      A0 (P6.0)|<---- Vin
//            |               |
//
//
//  M.Mitchell
//  Texas Instruments, Inc
//  January, 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include          "msp430x14x.h" // Standard Equations

void main(void)
{ 
  WDTCTL = WDTPW+WDTHOLD;               // Stop watchdog timer
  P6SEL |= 0x01;                        // Enable A/D channel A0
  
  TACTL = TASSEL_2+MC_2;                // Timer_A setup
  TACCTL1 = OUTMOD_3;                   // CCR1 setup
  TACCR1 = 0x0fff;                      // Compare value
  
  ADC12CTL0 = ADC12ON+SHT0_2;           // Turn on ADC12, set sampling time
  ADC12CTL1 = SHS_1+SHP;                // TAOUT.1 triggers sampling timer

   
  while (1)
  { 
    ADC12CTL0 |= ENC;                   // Enable conversions
    ADC12CTL0 |= ADC12SC;               // Start conversion
    while ((ADC12IFG & ADC12BUSY)==0);
    ADC12CTL0 &= ~ENC;                  // Clear ENC bit, SET BREAKPOINT HERE
  }                           
}  

