//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Sample A10Temp and Convert to oC and oF  
//
//  Description; A single sample is made on A10 with refernce to internal
//  1.5V Vref. Software sets ADC10SC to start sample and conversion - ADC10SC 
//  automatically cleared at EOC. ADC10 internal oscillator/4 times sample 
//  (64x) and conversion. In Mainloop MSP430 waits in LPM0 to save power until 
//  ADC10 conversion complete, ADC10_ISR will force exit from any LPMx in 
//  Mainloop on reti. Temperaure in oC stored in IntDegC, oF in IntDegF.
//
//  Uncalibrated temperature measured from device to devive will vary with 
//  slope and offset from device to device - please see datasheet.
//  //*MSP430F1232 or MSP430F1132 Device Required*//
//
//                MSP430F1232
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |A10              |
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>
unsigned int long temp;
unsigned int long IntDegF;
unsigned int long IntDegC;

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC10CTL1 = INCH_10+ADC10DIV_3;       // Temp Sensor ADC10CLK/4   
  ADC10CTL0 = SREF_1 + ADC10SHT_3 + REFON + ADC10ON + ADC10IE;
  
  while(1)
  {
    ADC10CTL0 |= ENC + ADC10SC;         // Sampling and conversion start
    _BIS_SR(CPUOFF + GIE);              // LPM0 with interrupts enabled
  
//  oF = ((A10/1024)*1500mV)-923mV)*1/1.97mV = x*761/1024 - 468 
    temp = ADC10MEM;
    IntDegF = ((temp - 630) * 761) / 1024;         

//  oC = ((A10/1024)*1500mV)-986mV)*1/3.55mV = x*423/1024 - 278 
    temp = ADC10MEM;
    IntDegC = ((temp - 673) * 423) / 1024;         

    _NOP();                             // SET BREAKPOINT HERE
  }
}

// ADC10 interrupt service routine
void ADC10_ISR (void) __interrupt[ADC10_VECTOR] 
{
    _BIC_SR_IRQ(CPUOFF);                // Clear CPUOFF bit from 0(SR)
}
