// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <ctl_api.h>
#include "test.h"

CTL_TASK_t mainTask, otherTask;
unsigned e1=0;

unsigned count = 0;
unsigned count2 = 0;

void 
buttonPressedISR(void)
{
  count++;
  ctl_set_clear_events(&e1, 1, 0);
}
          
unsigned otherStack[64];
void 
other(void *p)
{
  unsigned leds = 0;
  while (1)
    {
      ctl_task_wait(CTL_STATE_EVENT_WAIT | CTL_STATE_TIMER_WAIT, ctl_current_time+1000, &e1, 1);  
      ctl_set_clear_events(&e1, 0, 1);
      leds ^= 0xFFFFFFFF;
      SetLeds(leds);
    }
}

void
ctl_handle_error(CTL_ERROR_CODE_t e)
{
  while (1);
}

int main(void)
{
  BoardInit();
  ctl_task_init(&mainTask, 0, "main");
  SetTimerISR(ctl_increment_tick_from_isr);
  ctl_task_run(&otherTask, 1, other, 0, "other", sizeof(otherStack)/sizeof(unsigned), otherStack);
  SetButtonPressedISR(buttonPressedISR);
  while (1)
    Idle();
  return 0;
}
