function getState(state)
{
  if (state==0)
    return "runnable";
  else if (state==128)
    return "finished"
  else if ((state & 3)==3)
    return "event & timer wait";
  else if ((state & 1)==1)      
    return "timer wait";
  else if ((state & 2)==2)     
    return "event wait";
  else
    return "invalid";
}

function getregs(sp)
{
  var a = new Array();
  for (i=15;i>3;i--) // r15-r4 saved
    {
      a[i] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
      sp+=2;
    }
  a[3] = 0; // r3 isn't saved  
  a[2] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); // r2/sr
  sp+=2;
  a[0] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); // r0/pc
  a[1] = sp; // r1/sp
  return a;
}

function update() 
{
  Threads.clear();
  x=Debug.evaluate("ctl_task_executing");
  if (x)
    {
      Threads.newqueue("Executing");
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      Threads.add(x.name, x.priority, "executing", null);
    }
  x=Debug.evaluate("ctl_task_list");
  if (x)
    Threads.newqueue("Waiting");
  count=0;
  while (x && count<10)
    {
      count++;
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      state = getState(x.state);
      Threads.add(x.name, x.priority, state, getregs(x.stack_pointer));
      x=x.next;
    }
}