//******************************************************************************
//  MSP-FET430x110 Demo - Timer_A Toggle P1.1 With TA0 upmode, 32kHz ACLK  
//
//  Description; Toggle P1.1 using hardware TA0 output. Timer_A is configured
//  in upmode with CCR0 defining period, TA0 also output on P1.1. In this 
//  example, CCR0 is loaded with 10 and TA0 will toggling P.1 at TACLK/10.
//  Thus the ouput frequency on P1.1 will be the TACLK/20.  No CPU or software
//  resources required. Normal mode is LPM3.
//  ACLK =TACLK = 32kHz, MCLK = default DCO ~ 800kHz
//  As coded with TACLK = ACLK, P1.1 output frequency = 32768/20 = 1.6384kHz
//   
//            MSP430F1121
//         -----------------
//     /|\|              XIN|-  
//      | |                 | 32kHz
//      --|RST          XOUT|-
//        |                 |
//        |             P1.1|-->TA0 ACLK/20
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x11x1.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL0 + TACLR;              // ACLK, clear TAR
  CCTL0 = OUTMOD_4;                     // CCR0 toggle mode
  CCR0 = 10-1;
  P1DIR |= 0x02;                        // P1.1 output
  P1SEL |= 0x02;                        // P1.1 option select
  TACTL |= MC0;                         // Start Timer_a in upmode
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}
