//******************************************************************************
//  MSP-FET430P440 Demo - WDT Toggle P5.1 Interval overflow ISR, DCO SMCLK 
//
//  Description; Toggle P5.1 using software timed by the WDT ISR. Toggle rate 
//  is approximately 30ms based on default ~ 800khz DCO/SMCLK clock source 
//  used in this example for the WDT.  
//  ACLK = n/a, MCLK = SMCLK = default DCO ~ 800k
//
//		  MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |             P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDT_MDLY_32;                 // Set Watchdog Timer interval to ~30ms
  IE1 |= WDTIE;                         // Enable WDT interrupt
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

// Watchdog Timer interrupt service routine
void watchdog_timer(void) __interrupt[WDT_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

