#include <msp430.h>
	.text
	.code
	.align 0

	.public _start_timer
        .public _ticks_per_sec
        .public _ticks_per_mSec        
        .extern _ctl_interrupt_count
        .extern _ctl_exit_isr
        .extern _ctl_increment_tick_from_isr    
        
// This defines the timeout period for a millisecond timer
#define MS_TIMEOUT 500           

_start_timer:          
        mov.w   #TASSEL1+TACLR,&TACTL   ; SMCLK, clear TAR
        mov.w   #CCIE,&CCTL0            ; CCR0 interrupt enabled
        mov.w   #MS_TIMEOUT,&CCR0             ; 
        bis.w   #MC1,&TACTL             ; Start Timer_a in continous mode
        ret

_ticks_per_sec:
        mov #0, r15
        mov #1000, r14
        ret

_ticks_per_mSec:
        mov #1, r15
        ret  

TA0_ISR:
        push.w r4
        push.w r5
        push.w r6
        push.w r7
        push.w r8
        push.w r9
        push.w r10
        push.w r11
        push.w r12
        push.w r13
        push.w r14
        push.w r15        
        add.w #1, &_ctl_interrupt_count           
        
        call #_ctl_increment_tick_from_isr
        add.w #MS_TIMEOUT,&CCR0

        mov.w sp, r15        
        jmp _ctl_exit_isr
                                  
        .vectors
        .keep
        org 0xc
        dw TA0_ISR
                                                                 
                                          
