// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __stdlib_H
#define __stdlib_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __SIZE_T_DEFINED
#define __SIZE_T_DEFINED
typedef __SIZE_T size_t;
#endif

#ifndef NULL
#define NULL 0
#endif

/* Definition of the argument values for the exit() function */
#define EXIT_SUCCESS    0
#define EXIT_FAILURE    1

/* Definition of value for rand() function. */
#define RAND_MAX 32767

typedef struct
{
  int quot;
  int rem;
} div_t;

typedef struct
{
  long quot;
  long rem;
} ldiv_t;

typedef struct
{
  long long quot;
  long rem;
} lldiv_t;

int abs(int j);
long int labs(long int j);
long long int llabs(long long int j);

div_t div(int numer, int denom);
ldiv_t ldiv(long int numer, long int denom);
lldiv_t lldiv(long long int numer, long long int denom);

void *calloc(size_t nobj, size_t size);

void *malloc(size_t size);

void *realloc(void *p, size_t size);

void free(void *p);

int atoi(const char *nptr);
long int atol(const char *nptr);
long long int atoll(const char *nptr);

long int strtol(const char *nptr, char **endptr, int base);
long long int strtoll(const char *nptr, char **endptr, int base);
unsigned long int strtoul(const char *nptr, char **endptr, int base);
unsigned long long int strtoull(const char *nptr, char **endptr, int base);

int rand(void);
void srand(unsigned int seed);

void abort(void);

// Extensions
char *itoa(int val, char *buf, int radix);
char *utoa(int val, char *buf, int radix);
char *ltoa(long val, char *buf, int radix);
char *ultoa(unsigned long val, char *buf, int radix);
char *lltoa(long long val, char *buf, int radix);
char *ulltoa(unsigned long long val, char *buf, int radix);

#ifdef __cplusplus
}
#endif

#endif
