// Rowley MSP430 C Compiler
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __stdarg_H
#define __stdarg_H

// Get definition of __va_list
#include "__crossworks.h"

typedef __va_list va_list;
__va_list __va_base(void);  // intrinsic

#define va_start(ap,parmN) \
    ((void)((ap) = __va_base()))

#define va_arg(ap,type) \
    (*(type *)(((ap)=(ap)+sizeof(type))-sizeof(type)))

#define va_copy(dest,src) \
    ((void)((dest) = (src)))

#define va_end(ap) \
    ((void)((ap) = (void *)0))

#endif
