// Rowley MSP430 C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __in430_H
#define __in430_H

// Swap byte order within a word
unsigned _SWPB(unsigned);

// Swap word order within a long
unsigned long _SWPW(unsigned long);

// Swap byte order within a long
unsigned long _LSWPB(unsigned long);

// Set bits in status register and return original status register
unsigned _BIS_SR(unsigned);

// Clear bits in status register and return original status register
unsigned _BIC_SR(unsigned);

// Set bits in stacked IRQ status register and return original IRQ status register
unsigned _BIS_SR_IRQ(unsigned);

// Clear bits in stacked IRQ status register and return original IRQ status register
unsigned _BIC_SR_IRQ(unsigned);

// Disable interrupts and return original status register
#define _DINT()  _BIC_SR(8)

// Enable interrupts and return original status register
#define _EINT()  _BIS_SR(8)

// Insert a NOP to code sequence.
void _NOP(void);

// Insert op into code sequence
void _OPC(const unsigned op);

// Decimal add two BCD integers
unsigned _DADD16(unsigned, unsigned);

// Decimal add two BCD long integers
unsigned long _DADD32(unsigned long, unsigned long);

// Decimal add two BCD long long integers
unsigned long long _DADD64(unsigned long long, unsigned long long);

// Decimal subtract two BCD integers
unsigned _DSUB16(unsigned, unsigned);

// Decimal subtract two BCD long integers
unsigned long _DSUB32(unsigned long, unsigned long);

// Decimal subtract two BCD long long integers
unsigned long long _DSUB64(unsigned long long, unsigned long long);

// Decimal negate a BCD integer
unsigned _DNEG16(unsigned);

// Decimal negate a BCD long integer
unsigned long _DNEG32(unsigned long);

// Decimal negate a BCD long long integer
unsigned long long _DNEG64(unsigned long long);

// Get high 32 bits of 64-bit value
unsigned long _H32(unsigned long long);

// Get low 32 bits of 64-bit value
unsigned long _L32(unsigned long long);

// Get high 16 bits 64-bit value
unsigned _HH16(unsigned long long);

// Get low 16 bits 64-bit value
unsigned _LL16(unsigned long long);

#endif
