//******************************************************************************
//  MSP-FET430P440 Demo - LCD, displays numbers on 4 multiplex rate LCD
//
//  Description "FET440_4muxLCD": This program displays digits stored in the 
//  variable "value" on a 4 mux LCD, then waits in low power mode 3. To use the
//  program run it as is or assign a different BCD number (digits 0-9) to the
//  variable "value". 
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//  
//                                 Connections MSP430 -> LCD
//                                 -------------------------
//
//                                T.I.                  T.I.
//                           MSP430x44x MCU   STK/EVK 6.5 digit 4 mux LCD
//                                                    #T218010
//                           ---------------       --------------
//                          |          COM3 |-----|2    COM4     |
//                          |          COM2 |-----|1    COM3     |
//                          |          COM1 |-----|3    COM2     | 
//                          |          COM0 |-----|4,20 COM1     |
//                          |          SEG0 |-----|19            |
//                          |          SEG1 |-----|18            |
//                          |          SEG2 |-----|17            |
//                          |          SEG3 |-----|16            |  
//                          |          SEG4 |-----|15            |
//                          |          SEG5 |-----|14            |
//                          |          SEG6 |-----|13            |
//                          |          SEG7 |-----|12            |
//                          |          SEG8 |-----|11            | 
//                          |          SEG9 |-----|10            |
//                          |          SEG10|-----|9             |
//                          |          SEG11|-----|8             |
//                          |          SEG12|-----|7             | 
//                          |          SEG13|-----|6             |
//                          |          SEG14|-----|5 (bits C,E,H |
//                          |               |     |   of digit 7)|
//                          |               |      --------------
//                          |               | 
//                           ---------------  
//
//                   NOTE: Pin R03 on the MSP430 must be connected to GND
//
//  B. Merritt
//  Texas Instruments Inc.
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************
#include "msp430x44x.h"

char digit[10] = {
0xB7,  // "0"    LCD segments a+b+c+d+e+f 
0x12,  // "1" 
0x8F,  // "2" 
0x1F,  // "3" 
0x3A,  // "4" 
0x3D,  // "5" 
0xBD,  // "6" 
0x13,  // "7" 
0xBF,  // "8" 
0x3F   // "9" 
};

void main(void)
{
  unsigned int value = 43044;     // number to display, range = 0 to 65535
       // NOTE: DO NOT use leading zeros or it will be interpreted as octal data
  
  char *LCD = LCDMEM;
  unsigned int i;

  WDTCTL = WDTPW + WDTHOLD;   // Stop watchdog timer 
  FLL_CTL0 = XCAP18PF;        //set load capacitance for 32k xtal

  // Initialize LCD driver (4Mux mode) 
  LCDCTL = 0x03D;             // 4mux LCD, segs16-23 = outputs
  BTCTL  = BTFRFQ1;           // set LCD frame freq = ACLK
  P5SEL  = 0xFC;              // set Rxx and COM pins for LCD
  
  // clear LCD memory to clear display
  for (i=0; i<19; i++)
  {
    LCD[i] = 0;
  } 
  
  // display contents of the variable value 
  for (i=0; i<5; i++)
  {
    LCD[i] = digit[value%10]; // remainder = character in table to display
    value = value/10;         // shifts right so next character can be displayed
  } 
 
  LPM3;                       // enter low power mode 3 
}