//******************************************************************************
//  MSP-FET430P410 Demo - LCD, displays numbers on static LCD
//
//  Description "FET410_staticLCD.C": This program displays a 3.5 digit number
//  on a static LCD, then waits in low power mode 3. The leading digit must be 
//  '1', nothing else will display.  To use the program enter a 3.5 digit BCD 
//  (characters 0-9) number in the program for the interger 'value'. Download 
//  the program and run it. 
//  
//  
//                                 Connections MSP430 -> LCD
//                                 -------------------------
//
//                                T.I.               Varitronix  
//                           MSP430x41x MCU     3.5 digit, static LCD
//                                                 # VI-302-DP-S
//                           ---------------       --------------
//                          |          COM0 |-----|1,40 COM      |
//                          |          SEG0 |-----|21            |
//                          |          SEG1 |-----|20            |
//                          |          SEG2 |-----|19            |
//                          |          SEG3 |-----|18            |  
//                          |          SEG4 |-----|17            |
//                          |          SEG5 |-----|22            |
//                          |          SEG6 |-----|23            |
//                          |          SEG7 |-----|38 (low batt) |
//                          |          SEG8 |-----|25            | 
//                          |          SEG9 |-----|24            |
//                          |          SEG10|-----|15            |
//                          |          SEG11|-----|14            |
//                          |          SEG12|-----|13            | 
//                          |          SEG13|-----|26            |
//                          |          SEG14|-----|27            |
//                          |          SEG15|-----|28 (L)  COLON |
//                          |          SEG16|-----|30            | 
//                          |          SEG17|-----|29            |
//                          |          SEG18|-----|11            |
//                          |          SEG19|-----|10            |
//                       ---|R03       SEG20|-----|9             | 
//                      |   |          SEG21|-----|31            |
//                      |   |          SEG22|-----|32            |
//                     \|/  |          SEG23|-----|3 (B-C) =     |
//                     GND  |               |     | .5 digit ="1"|
//                           ---------------       --------------  
//
//                 NOTE: Pin R03 on the MSP430 must be connected to GND
//
//  B. Merritt
//  Texas Instruments Inc.
//  February 2002
//
//******************************************************************************
#include "msp430x41x.h"

// variable declaration //
unsigned int value = 1789;  // number to display, range = 0 - 1999 = max display
                            // NOTE: DO NOT use leading zeros
unsigned int h;
unsigned int i;
unsigned int dig_pntr;  
char *LCD = LCDMEM;
       

// array declaration //
char digit[40] = {
0x11, 0x11,  // "0"    LCD segments a+b & c+d = lower two bytes
0x11, 0x00,  // "0"    LCD segments e+f & g+h = upper two bytes
0x10, 0x01,  // "1" 
0x00, 0x00,  // "1" 
0x11, 0x10,  // "2" 
0x01, 0x01,  // "2" 
0x11, 0x11,  // "3" 
0x00, 0x01,  // "3" 
0x10, 0x01,  // "4" 
0x10, 0x01,  // "4" 
0x01, 0x11,  // "5"  
0x10, 0x01,  // "5"  
0x01, 0x11,  // "6" 
0x11, 0x01,  // "6" 
0x11, 0x01,  // "7" 
0x00, 0x00,  // "7" 
0x11, 0x11,  // "8" 
0x11, 0x01,  // "8" 
0x11, 0x11,  // "9" 
0x10, 0x01,  // "9" 
};


void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;     // stop watchdog timer
  FLL_CTL0 = XCAP18PF;          // set load capacitance for 32k xtal 

  // initialize LCD driver (static mode) //
  LCDCTL = 0x65;                //static LCD, segments = 0 - 23
  BTCTL  = BTFRFQ1+BTFRFQ0;     // BTCTL ;set fLCD = ACLK / 256 BTFRFQ1
  
  // set up ports //
  P1DIR = 0xFF;                 // set port to outputs
  P2DIR = 0xFF;                 // set port to outputs
  P3DIR = 0xFF;                 // set port to outputs
  P4DIR = 0xFF;                 // set port to outputs
  P5DIR = 0xFF;                 // set port to outputs
  P6DIR = 0xFF;                 // set port to outputs  
    
    
  // clear LCD memory to clear display //
  for (i=0; i<12; i++)
  {
    LCD[i] = 0;
  } 

  // display lower 3 digits //
  for (h=0; h<3; h++)           // loops to move 3 digits to LCD
  {
    dig_pntr = 4*(value%10);    // set pointer to start of digit in table

    for (i=0; i<4; i++)         // loops to load 4 bytes of digit
    {
      LCD[i] = digit[dig_pntr++]; // byte of digit to byte of LCD memory 
    }                           // and increment to next byte of digit
  
    value /= 10;                // shifts value right to display next character
    LCD += 4;                   // increment by 4 for next character location
  }
  
  // test for leading 1 and display if present //
  if (value == 1)
  {
    LCDM12 |= 0x10;             // set bit = leading 1
  }
 
  LPM3;                         // enter low power mode 3 
}    
    
