// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002, 2003 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __math_h
#define __math_h

extern const float __float32_infinity;
#ifndef __SHORT_DOUBLES
extern const double __float64_infinity;
#endif

#define INFINITY __infinity

#ifdef __SHORT_DOUBLES
#define HUGE_VAL __float32_infinity
#else
#define HUGE_VAL __float64_infinity
#endif
#define HUGE_VALF __float32_infinity

// Type-generic macros
#define isinf(x) ((__typecode(x) == __typecode(float) && sizeof(x) == sizeof(float)) ? __isinff(x) : __isinf(x))
#define isnan(x) ((__typecode(x) == __typecode(float) && sizeof(x) == sizeof(float)) ? __isnanf(x) : __isnan(x))
#define isfinite(x) ((__typecode(x) == __typecode(float) && sizeof(x) == sizeof(float)) ? __isfinitef(x) : __isfinite(x))
#define isnormal(x) ((__typecode(x) == __typecode(float) && sizeof(x) == sizeof(float)) ? __isnormalf(x) : __isnormal(x))
#define signbit(x) ((__typecode(x) == __typecode(float) && sizeof(x) == sizeof(float)) ? __signbitf(x) : __signbit(x))

typedef float float_t;
typedef double double_t;

float acosf(float);
double acos(double);

float asinf(float);
double asin(double);

float atanf(float);
double atan(double);

float atan2f(float, float);
double atan2(double, double);

float cosf(float);
double cos(double);

float sinf(float);
double sin(double);

float tanf(float);
double tan(double);

float coshf(float);
double cosh(double);

float sinhf(float);
double sinh(double);

float tanhf(float);
double tanh(double);

float expf(float);
double exp(double);

float frexpf(float, int *);
double frexp(double, int *);

float ldexpf(float, int);
double ldexp(double, int);

float scalbnf(float, int);
double scalbn(double, int);

float logf(float);
double log(double);

float log10f(float);
double log10(double);

float fmodf(float, float);
double fmod(double, double);

float modff(float, float *);
double modf(double, double *);

float powf(float, float);
double pow(double, double);

float sqrtf(float);
double sqrt(double);

float ceilf(float);
double ceil(double);

float fabsf(float);
double fabs(double);

float floorf(float);
double floor(double);

float hypotf(float, float);
double hypot(double, double);

float acoshf(float);
double acosh(double);

float asinhf(float);
double asinh(double);

float atanhf(float);
double atanh(double);

/* \brief Private functions. */
int __isinf(double);
int __isinff(float);
int __isnan(double);
int __isnanf(float);
int __isfinite(double);
int __isfinitef(float);

#endif
