//*******************************************************************************
//  MSP-FET430x110 Demo - Timer_A PWM TA1-2 up-downmode, HF XTAL ACLK
//
//  Description; This program will generate a two PWM outputs on P1.2/1.3 using
//  Timer_A in an upmode.  The value in CCR0, 128, defines the period/2 and the 
//  values in CCR1 and CCR1 the duty PWM cycles.  Using 32kHz ACLK as TACLK,
//  values in CCR1 and CCR1 the duty PWM cycles.  Using HF XTAL ACLK as TACLK,
//  the timer period is HF XTAL/256 with a 75% duty cycle on P1.2 and 25% on P1.3. 
//  ACLK = MCLK = TACLK = HF XTAL
//  As coded, the output signals TA1 on P1.2 and TA2 on P1.3 are inverted. 
//  //** HF XTAL REQUIRED AND NOT INSTALLED ON FET **//
//
//               MSP430F1121
//            -----------------
//        /|\|              XIN|-  
//         | |                 | HF XTAL (455k - 8Mhz) 
//         --|RST          XOUT|-
//           |                 |
//           |             P1.2|--> CCR1 - 75% PWM
//           |             P1.3|--> CCR2 - 25% PWM
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x11x1.h>

void main(void)
{ 
  unsigned int i;
  WDTCTL = WDTPW +WDTHOLD;              // Stop WDT
  BCSCTL1 |= XTS;                       // ACLK = LFXT1 = HF XTAL

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1+SELM0;               // MCLK = LFXT1 (safe)
  TACTL = TASSEL0 + TACLR;              // ACLK, Clear Tar
  CCR0 = 128;                           // PWM Period/2
  CCTL1 = OUTMOD_2;  			// CCR1 toggle/reset
  CCR1 = 64;                            // CCR1 PWM duty cycle
  CCTL2 = OUTMOD_6;  			// CCR2 reset/set
  CCR2 = 96;                            // CCR2 PWM duty cycle
  P1DIR |= 0x0C;                        // P1.2 and P1.3 output
  P1SEL |= 0x0C;                        // P1.2 and P1.3 TA1/2 otions
  TACTL |= MC1 + MC0;                   // Start Timer_A in up-down mode
  
  for (;;)                            
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

