//******************************************************************************
//  MSP-FET430P440 Demo - Timer_B Toggle P5.1, overflow ISR, 32kHz ACLK 
//
//  Description; Toggle P5.1 using using software and the timer_B overflow ISR. 
//  In this example an ISR will trigger when TB overflows.  Inside the ISR P5.1 
//  is toggled.  Toggle rate is exactly 0.25hz.
//  Proper use of TBIV interrupt vector generator demonstrated.
//  ACLK = TBCLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TBCTL = TBSSEL0 + TBCLR + TBIE;       // ACLK, clr. TBR, interrupt
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TBCTL |= MC1;                         // Start Timer_B in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer_B7 Interrupt Vector (TBIV) handler
void Timer_B(void) __interrupt [TIMERB1_VECTOR] 
{
 switch( TBIV )
 {
   case  2: break;                      // CCR1 not used
   case  4: break;                      // CCR2 not used
   case 14: P5OUT ^= 0x02;              // overflow
           break;
  }
}

