// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __cross_studio_io_H
#define __cross_studio_io_H

#define DEBUG_FILE void 
#define DEBUG_SEEK_CUR 1
#define DEBUG_SEEK_END 2
#define DEBUG_SEEK_SET 0
                         
DEBUG_FILE *debug_fopen(const char *filename, const char *mode); 
int debug_fflush(DEBUG_FILE *);
void debug_fclose(DEBUG_FILE *);

int debug_fprintf(DEBUG_FILE *, const char *fmt, ...);
int debug_printf(const char *fmt, ...);  

int debug_fscanf(DEBUG_FILE *, const char *fmt, ...);
int debug_scanf(const char *fmt, ...);  

int debug_getchar(void);
int debug_gets(char *s, int n);    
int debug_geti(int *);
int debug_getu(unsigned *);
int debug_getl(long *);
int debug_getul(unsigned long *);
int debug_getf(float *);
int debug_getd(double *);
int debug_getll(long long *);
int debug_getull(unsigned long long *);
   
int debug_fgetc(DEBUG_FILE *);
char *debug_fgets(char *s, int n, DEBUG_FILE *);
int debug_fputc(int c, DEBUG_FILE *);                        
int debug_fputs(const char *s, DEBUG_FILE *);
int debug_putchar(int c);
int debug_puts(const char *s);

int debug_fread(void *ptr, int size, int nobj, DEBUG_FILE *);
int debug_fwrite(void *ptr, int size, int nobj, DEBUG_FILE *);

int debug_fseek(DEBUG_FILE *, long offset, int origin);
int debug_ftell(DEBUG_FILE *, long *offset);
void debug_rewind(DEBUG_FILE *);
int debug_filesize(DEBUG_FILE *);

void debug_clearerr(DEBUG_FILE *);
int debug_feof(DEBUG_FILE *);
int debug_ferror(DEBUG_FILE *);

int debug_kbhit(void);
int debug_getch(void);

int debug_ioctl(int cmd, int param);

void debug_runtime_error(const char *error);

void debug_break(void);


#endif

