// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// Can include <assert.h> multiple times, so this doesn't use the standard
// #ifndef/#define idiom.

#ifndef __assert_h
#define __assert_h

#ifdef __cplusplus
extern "C" {
#endif

extern void __assert(const char *, const char *, int);

#ifdef __cplusplus
}
#endif

#else
#undef assert
#endif

#ifdef NDEBUG
#define assert(ignore) ((void)0)
#else
#define assert(e) ((e) ? (void)0 : __assert(#e, __FILE__, __LINE__))
#endif
