// Rowley C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// Documented API addresses
getROMAPI          = 800020h*2    ; Returns a version number in Acc; xxxxyyyy, where xxxx is the major version number and yyyy is the minor.
getFunctionAddress = 800024h*2    ; function number (0-based) is provided in Acc
moveDP0_B          = 800028h*2    ; move Acc, @DP[0].B
moveDP0_W          = 80002Ch*2    ; move Acc, @DP[0].W
moveDP0_L          = 800030h*2    ; move Acc, @DP[0].L
moveDP0inc_B       = 800034h*2    ; move Acc, @DP[0].B++
moveDP0inc_W       = 800038h*2    ; move Acc, @DP[0].W++
moveDP0inc_L       = 80003Ch*2    ; move Acc, @DP[0].L++
moveDP0dec_B       = 800040h*2    ; move Acc, @DP[0].B--
moveDP0dec_W       = 800044h*2    ; move Acc, @DP[0].W--
moveDP0dec_L       = 800048h*2    ; move Acc, @DP[0].L--
moveDP1_B          = 80004Ch*2    ; move Acc, @DP[1].B
moveDP1_W          = 800050h*2    ; move Acc, @DP[1].W
moveDP1_L          = 800054h*2    ; move Acc, @DP[1].L
moveDP1inc_B       = 800058h*2    ; move Acc, @DP[1].B++
moveDP1inc_W       = 80005Ch*2    ; move Acc, @DP[1].W++
moveDP1inc_L       = 800060h*2    ; move Acc, @DP[1].L++
moveDP1dec_B       = 800064h*2    ; move Acc, @DP[1].B--
moveDP1dec_W       = 800068h*2    ; move Acc, @DP[1].W--
moveDP1dec_L       = 80006Ch*2    ; move Acc, @DP[1].L--
moveBP_B           = 800070h*2    ; move Acc, @BP[Offs].B
moveBP_W           = 800074h*2    ; move Acc, @BP[Offs].W
moveBP_L           = 800078h*2    ; move Acc, @BP[Offs].L
moveBPinc_B        = 80007Ch*2    ; move Acc, @BP[Offs++].B
moveBPinc_W        = 800080h*2    ; move Acc, @BP[Offs++].W
moveBPinc_L        = 800084h*2    ; move Acc, @BP[Offs++].L
moveBPdec_B        = 800088h*2    ; move Acc, @BP[Offs--].B
moveBPdec_W        = 80008Ch*2    ; move Acc, @BP[Offs--].W
moveBPdec_L        = 800090h*2    ; move Acc, @BP[Offs--].L

        public  start

        data
        bss
        code
        priority 0

        psect   "STARTUP"
        even
start:

; Enable auto accumulator tracking
        move    AP, #0
        move    A[0], SC
        or      #0x200
        move    SC, A[0]

; Disable modulo updates.
        move    APC, #0x00

; Set up SP to ed of memory, don't rely on reset.
        move    SP, #_RAM_Start_Address+_RAM_Size  ; set up stack pointer

        LINKIF  SIZEOF(IDATA0)
        move    DP[0], #SFB(IDATA0)
        move    DP[1], #data_init_begin+0x1000000 ; point into ROM, byte address
        move    LC[0], #data_init_end-data_init_begin+1
        jump    L$0
        move    AP, #0
L$1     call    moveDP1inc_B
        move    @DP[0].B++, A[0]
L$0     djnz    LC[0], L$1
        ENDLINKIF

        LINKIF  SIZEOF(UDATA0)
        move    DP[0], #SFB(UDATA0)
        move    LC[0], #SIZEOF(UDATA0)+1
        jump    L$2
L$3     move    @DP[0].B++, #0
L$2     djnz    LC[0], L$3
        ENDLINKIF

        jump    _main

        const
data_init_begin:
        init "IDATA0"
data_init_end:

        code
        even
UROM_DP0_INC
        ret
        break

        code
        even
UROM_DP1_INC
        ret
        break

        code
        even
_setIV::
        move  IV, A[7]
        ret


