// Rowley C Compiler, runtime support.
//
// Copyright (c) 2004, 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __string_c_H
#define __string_c_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __SIZE_T_DEFINED
#define __SIZE_T_DEFINED
typedef __SIZE_T size_t;
#endif

#ifndef NULL
#define NULL 0
#endif

void *memcpy_c(void *s1, const __code void *s2, size_t n);
int memcmp_c(const void *s1, const __code void *s2, size_t n);

char *strcpy_c(char *s1, const __code char *s2);
char *strncpy_c(char *s1, const __code char *s, size_t n);
char *strcat_c(char *s1, const __code char *s2);
int strcmp_c(const char *s1, const __code char *s2);
int strncmp_c(const char *s1, const __code char *s2, size_t n);
size_t strlen_c(const __code char *s);

#ifdef __cplusplus
}
#endif

#endif

