// Rowley MSP430 C Compiler
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __stdarg_H
#define __stdarg_H

// Get definition of __va_list
#include "__crossworks.h"

#ifdef __CROSSWORKS

typedef __va_list va_list;
__va_list __va_base(int);  // intrinsic

#define va_start(ap,parmN) \
    ((void)((ap) = __va_base(0)))

#define va_arg(ap,type) \
    (*(type *)(((ap)=(ap)+sizeof(type))-sizeof(type)))

#define va_copy(dest,src) \
    ((void)((dest) = (src)))

#define va_end(ap) \
    ((void)((ap) = (void *)0))

#else

typedef __va_list va_list;

#define va_start(v,l) \
    __builtin_stdarg_start((v),l) 

#define va_arg \
    __builtin_va_arg

#define va_copy(d,s) \
    __builtin_va_copy((d),(s))

#define va_end(ap) \
    __builtin_va_end(ap)

#endif

#endif
