// Rowley C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

        public  UROM_DP0_INC
        public  UROM_DP1_INC
        public  start

        data
        bss
        code
        priority 0

// Define this to call directly into the MAXQ2000 UROM
#undef MAXQ2000_UROM_1V01

// Define this to call indirectly to all MAXQ20 UROM routines
#define MAXQ_UROM_GENERIC

        psect   "STARTUP"
        even
start:
        move    APC, #0x00
        move    A[8], #0x3f0

        LINKIF  SIZEOF(IDATA0) | SIZEOF(UDATA0)
        move    DPC, #0x10  ; DP[0] byte mode, DP[1] byte mode, BP word mode
        ENDLINKIF

        LINKIF  SIZEOF(IDATA0)
        move    BP, #0x800d
        move    OFFS, #0
        move    BP, @BP[OFFS]
        move    OFFS, #7  ; moveDP1inc
        move    A[0], @BP[OFFS]
        move    DP[0], #SFB(IDATA0)-1
        move    DP[1], #data_init_begin+0x8000 ; point into ROM
        move    LC[0], #data_init_end-data_init_begin+1
        jump    L$0
L$1     call    A[0]  ; get data byte from flash
        move    @++DP[0], GRL
L$0     djnz    LC[0], L$1
        ENDLINKIF

        LINKIF  SIZEOF(UDATA0)
        move    DP[0], #SFB(UDATA0)-1
        move    LC[0], #SIZEOF(UDATA0)+1
        jump    L$2
L$3     move    @++DP[0], #0
L$2     djnz    LC[0], L$3
        ENDLINKIF

        move    DPC, #0x18  ; DP[0] byte mode, DP[1] word mode, BP word mode

        jump    _main

        const
data_init_begin:
        init "IDATA0"
data_init_end:

#if defined(MAXQ2000_UROM_1V01)

UROM_DP0_INC equ 0x848A << 1
UROM_DP1_INC equ 0x8493 << 1

#elif defined (MAXQ_UROM_GENERIC)

        code
        even
UROM_DP0_INC
        push    DP[1]
        move    DP[1], #0x800d
        move    DP[1], @DP[1]
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    GR, @DP[1]
        pop     DP[1]
        jump    GR
        break

        code
        even
UROM_DP1_INC
        push    DP[1]
        move    DP[1], #0x800d
        move    DP[1], @DP[1]
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    NUL, @DP[1]++
        move    GR, @DP[1]
        pop     DP[1]
        jump    GR
        break

#else
#error "UROM entry point must be set up"
#endif

        code
        even
_setIV::
        move  IV, A[7]
        ret


