// Rowley MAXQ20 C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// Unsigned 16-bit by 16-bit integer multiply to 32-bit product

// Inputs:
//    A[7] - multiplier
//    A[6] - multiplicand
// Outputs:
//    A[7:6] - product
//    All other non-volatile registers preserved

// Hardware:
//    Minimum = 9 cycles
//    Maximum = 9 cycles
// Software:
//    Minimum = 17 cycles
//    Maximum = 155 cycles

#define MAXQ2000 2000
#define MAXQ3100 3100
#define MAXQ3120 3120
#define MAXQ7654 7654

#if __TARGET_PROCESSOR == MAXQ2000
#define HARDWARE_MULTIPLY
#define MCNT  M2[0]
#define MA    M2[1]
#define MB    M2[2]
#define MC2   M2[3]
#define MC1   M2[4]
#define MC0   M2[5]

#elif __TARGET_PROCESSOR == MAXQ3120
#define HARDWARE_MULTIPLY
#define MCNT  M3[0]
#define MA    M3[1]
#define MB    M3[2]
#define MC2   M3[3]
#define MC1   M3[4]
#define MC0   M3[5]

#elif __TARGET_PROCESSOR == MAXQ7654
#define HARDWARE_MULTIPLY
#define MCNT  M1[0]
#define MA    M1[1]
#define MB    M1[2]
#define MC2   M1[3]
#define MC1   M1[4]
#define MC0   M1[5]

#elif __TARGET_PROCESSOR == MAXQ3100
#undef HARDWARE_MULTIPLY

#else
#error Bad target processor
#endif

        code
        export  ___uint32_mul_16x16

___uint32_mul_16x16 proc

#ifdef HARDWARE_MULTIPLY

; Save IC so we can restore IGE on exit.
        move    GR, IC

; Disable interrupts.
        move    IC.0, #0

; Form product.
        move    MCNT, #0x21           ; CLD SUS - simple multiply
        move    MA, A[7]
        move    MB, A[6]
        nop
        move    A[6], MC0
        move    A[7], MC1             ; result

; Restore IC and return.
        move    IC, GR
        ret

#else

        public  ___uint32_mul_16x16_aux

; Save A[3].
        move    LC[0], A[3]

; Clear product and extended 
        move    A[4], #0
___uint32_mul_16x16_aux
        move    A[3], #0

; Zero extended multiplicand
        move    A[5], A[6]
        move    A[6], #0

; Set AP incrementing modulo 16.
        move    APC, #4

; Multiply step.
        move    AP, #7
L$0     sr
        jump    nc, L$1
        move    AP, #3
        add     A[5]
        addc    A[6]
L$1     move    AP, #5
        sla
        rlc

; Bits still left to multiply?
        jump    nz, L$0

; Restore default APC
        move    APC, #0

; Restore A[3] and return product.
        move    A[7], A[4]
        move    A[6], A[3]
        move    A[3], LC[0]
        ret

#endif

        endproc

