// Rowley MAXQ20 C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// 16-bit by 16-bit integer multiply

// Inputs:
//    A[7] - multiplier
//    A[6] - multiplicand
// Outputs:
//    A[7:6] - product
//    All other non-volatile registers preserved

// Hardware:
//    Minimum = 9 cycles
//    Maximum = 9 cycles
// Software:
//    Minimum = 10 cycles
//    Maximum = 117 cycles

; Hardware multiplier registers

#define MAXQ2000 2000
#define MAXQ3100 3100
#define MAXQ3120 3120
#define MAXQ7654 7654

#if __TARGET_PROCESSOR == MAXQ2000
#define HARDWARE_MULTIPLY
#define MCNT  M2[0]
#define MA    M2[1]
#define MB    M2[2]
#define MC2   M2[3]
#define MC1   M2[4]
#define MC0   M2[5]

#elif __TARGET_PROCESSOR == MAXQ3120
#define HARDWARE_MULTIPLY
#define MCNT  M3[0]
#define MA    M3[1]
#define MB    M3[2]
#define MC2   M3[3]
#define MC1   M3[4]
#define MC0   M3[5]

#elif __TARGET_PROCESSOR == MAXQ7654
#define HARDWARE_MULTIPLY
#define MCNT  M1[0]
#define MA    M1[1]
#define MB    M1[2]
#define MC2   M1[3]
#define MC1   M1[4]
#define MC0   M1[5]

#elif __TARGET_PROCESSOR == MAXQ3100
#undef HARDWARE_MULTIPLY

#else
#error Bad target processor
#endif

        code
        export  ___int32_mul_16x16

___int32_mul_16x16 proc

#ifdef HARDWARE_MULTIPLY

; Save IC so we can restore IGE on exit.
        move    GR, IC

; Disable interrupts.
        move    IC.0, #0

; Form low product).
        move    MCNT, #0x20           ; CLD - simple signed multiply
        move    MA, A[7]
        move    MB, A[6]
        nop
        move    A[7], MC1             ; result
        move    A[6], MC0

; Restore IC and return.
        move    IC, GR
        ret

#else

; Save A[3].
        move    LC[0], A[3]

; Clear product.
        move    A[4], #0

; Compute adjustment for high product word.
        move    AP, #7
        move    C, ACC.15
        jnc     L$1
        move    AP, #4
        sub     A[6]
L$1     move    AP, #6
        move    C, ACC.15
        jnc     ___uint32_mul_16x16_aux
        move    AP, #4
        sub     A[7]
        jump    ___uint32_mul_16x16_aux
#endif

        endproc

