// Rowley MAXQ20 C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// 32-bit by 32-bit integer multiply

// Inputs:
//    A[7]:A[6] - multiplier
//    A[5]:A[4] - multiplicand
// Outputs:
//    A[7]:A[6] - product
//    All other non-volatile registers preserved

// Hardware:
//    Minimum = 15 cycles
//    Maximum = 15 cycles
// Software:
//    Minimum = 21 cycles
//    Maximum = 305 cycles  (IAR: 451 fixed)

#define MAXQ2000 2000
#define MAXQ3100 3100
#define MAXQ3120 3120
#define MAXQ7654 7654

#if __TARGET_PROCESSOR == MAXQ2000
#define HARDWARE_MULTIPLY
#define MCNT  M2[0]
#define MA    M2[1]
#define MB    M2[2]
#define MC2   M2[3]
#define MC1   M2[4]
#define MC0   M2[5]

#elif __TARGET_PROCESSOR == MAXQ3120
#define HARDWARE_MULTIPLY
#define MCNT  M3[0]
#define MA    M3[1]
#define MB    M3[2]
#define MC2   M3[3]
#define MC1   M3[4]
#define MC0   M3[5]

#elif __TARGET_PROCESSOR == MAXQ7654
#define HARDWARE_MULTIPLY
#define MCNT  M1[0]
#define MA    M1[1]
#define MB    M1[2]
#define MC2   M1[3]
#define MC1   M1[4]
#define MC0   M1[5]

#elif __TARGET_PROCESSOR == MAXQ3100
#undef HARDWARE_MULTIPLY

#else
#error Bad target processor
#endif

        code
        export  ___int32_mul
        
___int32_mul proc

#ifdef HARDWARE_MULTIPLY
        
; Save IC so we can restore IGE on exit.
        move    GR, IC

; Disable interrupts.
        move    IC.0, #0

; Form low product (low1 * low2).
        move    MCNT, #0x23           ; CLD MMAC SUS - MAC multiply
        move    MA, A[4]
        move    MB, A[6]
        move    MA, A[5]              ; sneak in for next MAC
        move    a[6], MC0             ; low result of low1*low2  (a[4] * a[6])

; Shift down high part of low1*low2 ready for MAC.
        move    MC0, MC1
        move    MC1, #0

; Calculate and sum low1 * high2, note MA written above
        move    MB, MB                ; low1 * high2  (a[5] * a[6])

; Calculate and sum high1 * low2
        move    MA, A[4]
        move    MB, A[7]              ; high1 * low2  (a[4] * a[7])

; Wait for result
        nop
        move    A[7], MC0

; Restore IC and return.
        move    IC, GR
        ret

#else

; Multiplication by clockwork.  Save working registers.
        move    LC[0], A[2]
        move    LC[1], A[3]

; Set AP incrementing modulo 16.
        move    APC, #4

; Clear product
        move    A[2], #0
        move    A[3], #0

; Treat each half of the multiplier separately
L$0     move    AP, #6
L$x     sr
        jnc     L$1
        move    AP, #2
        add     A[4]
        addc    A[5]
L$1     move    AP, #7
        sr
        jnc     L$2
        move    AP, #3
        add     A[4]

; Update shift register
L$2     move    AP, #4
        sla
        rlc

; Continue until all bits shifted out of multiplicand.
        jump    nz, L$x
        move    AP, #7
        jump    nz, L$0

; Move product to result registers.
        move    A[6], A[2]
        move    A[7], A[3]

; Restore working registers
        move    A[2], LC[0]
        move    A[3], LC[1]

; Restore default APC
        move    APC, #0
        ret

#endif

        endproc
