// Rowley MAXQ20 C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

// 16-bit by 16-bit integer multiply

// Inputs:
//    A[7] - multiplier
//    A[6] - multiplicand
// Outputs:
//    A[7] - product
//    All other non-volatile registers preserved

// Hardware:
//    Minimum = 8 cycles
//    Maximum = 8 cycles
// Software:
//    Minimum = 10 cycles
//    Maximum = 117 cycles  (IAR: 130 fixed)

#define MAXQ2000 2000
#define MAXQ3100 3100
#define MAXQ3120 3120
#define MAXQ7654 7654

#if __TARGET_PROCESSOR == MAXQ2000
#define HARDWARE_MULTIPLY
#define MCNT  M2[0]
#define MA    M2[1]
#define MB    M2[2]
#define MC2   M2[3]
#define MC1   M2[4]
#define MC0   M2[5]

#elif __TARGET_PROCESSOR == MAXQ3120
#define HARDWARE_MULTIPLY
#define MCNT  M3[0]
#define MA    M3[1]
#define MB    M3[2]
#define MC2   M3[3]
#define MC1   M3[4]
#define MC0   M3[5]

#elif __TARGET_PROCESSOR == MAXQ7654
#define HARDWARE_MULTIPLY
#define MCNT  M1[0]
#define MA    M1[1]
#define MB    M1[2]
#define MC2   M1[3]
#define MC1   M1[4]
#define MC0   M1[5]

#elif __TARGET_PROCESSOR == MAXQ3100
#undef HARDWARE_MULTIPLY

#else
#error Bad target processor
#endif

        code
        export  ___int16_mul

___int16_mul proc

#ifdef HARDWARE_MULTIPLY
        
; Save IC so we can restore IGE on exit.
        move    GR, IC

; Disable interrupts.
        move    IC.0, #0

; Form low product).
        move    MCNT, #0x21           ; CLD SUS - simple multiply
        move    MA, A[7]
        move    MB, A[6]
        nop
        move    A[7], MC0             ; result

; Restore IC and return.
        move    IC, GR
        ret

#else

; Clear product
        move    A[5], #0

; Set AP incrementing modulo 16.
        move    APC, #4

; Multiply step.
        move    AP, #7
L$0     sr
        jump    nc, L$1
        move    AP, #5
        add     A[6]
L$1     move    AP, #6
        sla

; Bits still left to multiply?
        jump    nz, L$0

; Restore default APC
        move    APC, #0

; Return product.
        move    A[7], A[5]
        ret
#endif

        endproc

