// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 MAXQ2000 Evaluation Kit LED Example
//
// Description
// -----------
// This example demonstrates writing to the LCD display.
//
////////////////////////////////////////////////////////////////////////////////

#include <MAXQ2000.h>

#define LCD_PATTERN_0 0x03F
#define LCD_PATTERN_1 0x006
#define LCD_PATTERN_2 0x05B
#define LCD_PATTERN_3 0x04F
#define LCD_PATTERN_4 0x066
#define LCD_PATTERN_5 0x06D
#define LCD_PATTERN_6 0x07D
#define LCD_PATTERN_7 0x007
#define LCD_PATTERN_8 0x07F
#define LCD_PATTERN_9 0x067
#define LCD_PATTERN_A 0x077
#define LCD_PATTERN_B 0x07C
#define LCD_PATTERN_C 0x039
#define LCD_PATTERN_D 0x05E
#define LCD_PATTERN_E 0x079
#define LCD_PATTERN_F 0x071

const int lcd_numbers[16] = 
{
  LCD_PATTERN_0,
  LCD_PATTERN_1,
  LCD_PATTERN_2,
  LCD_PATTERN_3,
  LCD_PATTERN_4,
  LCD_PATTERN_5,
  LCD_PATTERN_6,
  LCD_PATTERN_7,
  LCD_PATTERN_8,
  LCD_PATTERN_9,
  LCD_PATTERN_A,
  LCD_PATTERN_B,
  LCD_PATTERN_C,
  LCD_PATTERN_D,
  LCD_PATTERN_E,
  LCD_PATTERN_F
};

void
delay(void)
{     
  long d;
  for(d=600000; d; --d);
}

int
main(void)
{
  int i;
  LCRA = 0x03E0; // set frame rate and duty cycle
  LCFG = 0x0F3; // set pins for LCD controller
  while (1)
    {
      int n = i;
      LCD0 = lcd_numbers[n % 10]; 
      n /= 10;
      LCD1 = lcd_numbers[n % 10];
      n /= 10;
      LCD2 = lcd_numbers[n % 10];
      n /= 10;
      LCD3 = lcd_numbers[n % 10];
      i++;
      if (i == 10000)
        i = 0;
      delay();
    }
}

