;* --------------------------------------------------------------------------------------
;*  Copyright (C) 2004 Dallas Semiconductor Corporation, All Rights Reserved.
;* 
;*  Permission is hereby granted, free of charge, to any person obtaining a
;*  copy of this software and associated documentation files (the "Software"),
;*  to deal in the Software without restriction, including without limitation
;*  the rights to use, copy, modify, merge, publish, distribute, sublicense,
;*  and/or sell copies of the Software, and to permit persons to whom the
;*  Software is furnished to do so, subject to the following conditions:
;* 
;*  The above copyright notice and this permission notice shall be included
;*  in all copies or substantial portions of the Software.
;* 
;*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;*  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;*  MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;*  IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
;*  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;*  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;*  OTHER DEALINGS IN THE SOFTWARE.
;* 
;*  Except as contained in this notice, the name of Dallas Semiconductor
;*  shall not be used except as stated in the Dallas Semiconductor
;*  Branding Policy.
;*
;*  Module:        maxq2000ev_1407
;*  Description:   Constants used by the MAX1407 library.
;*  Filename:      maxq2000ev_1407
;*  Date:          November 2, 2004
;*  Version:       1.00
;*
;* --------------------------------------------------------------------------------------

#define MAX1407_READ_MASK 		0C0h
#define MAX1407_WRITE_MASK 		080h

; Register addresses for the MAX1407
#define MAX1407REG_ADC          00h
#define MAX1407REG_MUX          01h
#define MAX1407REG_DATA         02h
#define MAX1407REG_OFFSET       03h
#define MAX1407REG_DAC1         04h
#define MAX1407REG_DAC2         05h
#define MAX1407REG_STATUS       06h
#define MAX1407REG_ALBURST      08h
#define MAX1407REG_ALSEC        09h
#define MAX1407REG_ALMIN        0Ah
#define MAX1407REG_ALHOUR       0Bh
#define MAX1407REG_ALDAY        0Ch
#define MAX1407REG_ALSTATUS     0Dh
#define MAX1407REG_CLOCKCTL     0Eh
#define MAX1407REG_RTCBURST     0Fh
#define MAX1407REG_RTCSEC       10h
#define MAX1407REG_RTCMIN       11h
#define MAX1407REG_RTCHOUR      12h
#define MAX1407REG_RTCDATE      13h
#define MAX1407REG_RTCMONTH     14h
#define MAX1407REG_RTCDAY       15h
#define MAX1407REG_RTCYEAR      16h
#define MAX1407REG_RTCCENTURY   17h
#define MAX1407REG_POWER1       18h
#define MAX1407REG_POWER2       19h
#define MAX1407REG_SLEEP        1Ah
#define MAX1407REG_STANDBY      1Bh
#define MAX1407REG_IDLE         1Ch
#define MAX1407REG_RUN          1Dh
